async function sleep(bot) {
    // Define the set of bed names for faster lookup
    const bedTypes = new Set([
        'gray_bed', 'light_blue_bed', 'purple_bed', 'white_bed', 'black_bed',
        'blue_bed', 'brown_bed', 'cyan_bed', 'green_bed', 'light_gray_bed',
        'lime_bed', 'magenta_bed', 'orange_bed', 'pink_bed', 'red_bed', 'yellow_bed'
    ]);

    // Find the nearest bed within a 32-block radius
    const beds = bot.findBlocks({
        matching: block => bedTypes.has(block.name),
        maxDistance: 32,
        count: 1
    });

    if (beds.length === 0) {
        bot.chat("No bed found nearby.");
        return;
    }

    const bedBlock = bot.blockAt(beds[0]);

    try {
        // Move to the bed's position
        await bot.pathfinder.goto(new GoalGetToBlock(bedBlock.position.x, bedBlock.position.y, bedBlock.position.z));
        
        // Attempt to sleep in the bed
        await bot.sleep(bedBlock);
        bot.chat("Goodnight!");
    } catch (err) {
        bot.chat(`Failed to sleep: ${err.message}`);
    }
}
